unit Main;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, OvcBase, OvcVlb, ExtCtrls;

type
  TAgenda = record
    Nome,
    Fone : String;
  end;
  TformAgendaMain10 = class(TForm)
    editNome: TEdit;
    editFone: TEdit;
    buttonAdiciona: TButton;
    buttonProcura: TButton;
    buttonExclui: TButton;
    Label1: TLabel;
    Label2: TLabel;
    panelStatus: TPanel;
    buttonNext: TButton;
    buttonPrev: TButton;
    procedure FormCreate(Sender: TObject);
    procedure buttonAdicionaClick(Sender: TObject);
    procedure buttonProcuraClick(Sender: TObject);
    procedure buttonPrevClick(Sender: TObject);
    procedure buttonNextClick(Sender: TObject);
    procedure buttonExcluiClick(Sender: TObject);
  private
    { Private declarations }
    {Dados e arquivo de dados}
    Agenda : TAgenda;
    FAgenda : File of TAgenda;
    {ndice de nomes}
    IAgenda,
    {ndice de nomes deletados}
    EAgenda : File of LongInt;
    {Registro corrente do ndice e arquivo de dados}
    IRegistro,
    Registro : LongInt;
    {Path do executvel, onde os arquivos de dados sero criados}
    MainPath : String;
    procedure AddReg(Position:LongInt);
    procedure AdicionaBusca(SType:Integer);
    procedure AbreArquivos;
    procedure FechaArquivos;
    procedure UpdateScreen;
    procedure LeRegistro(IdxPos:LongInt);
  public
    { Public declarations }
  end;

var
  formAgendaMain10: TformAgendaMain10;

implementation

{$R *.DFM}

{Adiciona um registro no fim do arquivo de dados, ou em um espao livre, caso haja
algum registro deletado disponvel e reescreve os arquivos de ndice}
procedure TformAgendaMain10.AddReg(Position:LongInt);
Var F : File of LongInt;
    IR,DR,R : LongInt;
begin
  if FileSize(EAgenda)<>0 then
  begin
    Seek(EAgenda,0);
    Read(EAgenda,DR);
    AssignFile(F,MainPath+'TEMP.TMP');
    Rewrite(F);
    While not Eof(EAgenda) do
    begin
      Read(EAgenda,R);
      Write(F,R);
    end;
    CloseFile(F);
    CloseFile(EAgenda);
    DeleteFile(MainPath+'FONES.MEI');
    RenameFile(MainPath+'TEMP.TMP','FONES.MEI');
    Reset(EAgenda);
  end else DR := FileSize(IAgenda);
  if Position=FileSize(IAgenda) then
  begin
    Seek(IAgenda,FileSize(IAgenda));
    Write(IAgenda,DR);
  end else
  begin
    AssignFile(F,MainPath+'TEMP.TMP');
    Rewrite(F);
    Seek(IAgenda,0);
    repeat
      if FilePos(IAgenda)=Position then Write(F,DR);
      if not Eof(IAgenda) then
      begin
        Read(IAgenda,IR);
        Write(F,IR);
      end;
    until Eof(IAgenda);
    CloseFile(F);
    CloseFile(IAgenda);
    DeleteFile(MainPath+'FONES.MDI');
    RenameFile(MainPath+'TEMP.TMP','FONES.MDI');
    Reset(IAgenda);
  end;
  Seek(FAgenda,DR);
  Agenda.Nome := editNome.Text;
  Agenda.Fone := editFone.Text;
  Write(FAgenda,Agenda);
end;

{Le um registro, baseado no ndice}
procedure TformAgendaMain10.LeRegistro(IdxPos:LongInt);
begin
  Seek(IAgenda,IdxPos);
  Read(IAgenda,Registro);
  Seek(FAgenda,Registro);
  Read(FAgenda,Agenda);
end;

{Atualiza status e ativa ou desativa os botes da tela}
procedure TformAgendaMain10.UpdateScreen;
begin
  buttonNext.Enabled := IRegistro<FileSize(IAgenda)-1;
  buttonPrev.Enabled := IRegistro>0;
  buttonExclui.Enabled := FileSize(IAgenda)>0;
  buttonProcura.Enabled := FileSize(IAgenda)>0;
  panelStatus.Caption := ' Telefones Cadastrados: '+IntToStr(FileSize(IAgenda));
end;

{Abre ou cria os arquivos, de acordo com a necessidade}
procedure TformAgendaMain10.AbreArquivos;
begin
  FileMode := 66;
  try
    Reset(FAgenda);
    Reset(IAgenda);
    Reset(EAgenda);
  except
    try
      Rewrite(FAgenda);
      Rewrite(IAgenda);
      Rewrite(EAgenda);
    except
      MessageBox(Handle,'Impossvel criar arquivos. Verifique se o disco est cheio, ou protegido contra'+
        ' gravao.','Aviso',MB_ICONSTOP+MB_OK+MB_TASKMODAL);
      Application.Terminate;
      Exit;
    end;
  end;
end;

{Fecha os arquivos. Os arquivos s ficam abertos durante as operaes de leitura e
gravao, por segurana}
procedure TformAgendaMain10.FechaArquivos;
begin
  try
    CloseFile(FAgenda);
  finally
  end;
  try
    CloseFile(IAgenda);
  finally
  end;
  try
    CloseFile(EAgenda);
  finally
  end;
end;

{De acordo com o parametro enviado, esta procedure adiciona ou busca
um registro. No so permitidos nomes repetidos. A comparao foi escrita manualmente,
pois o AnsiCompareText processa os acentos de forma diferente, de acordo com a lngua
do Windows, e definitivamente no queremos isto. Em caso de adio, um arquivo de semforo
 criado. Se uma cpia deste programa estiver sendo executada em uma rede, por exemplo, isso
garante que um programa s adicione registros no arquivo aps o outro ter finalizado seu
trabalho.}
procedure TformAgendaMain10.AdicionaBusca(SType:Integer);
{SType = 1 - Adicionar
 SType = 2 - Buscar}
var I,F,M : LongInt;
    StrUsr,StrData : String;
    TPC : Array [0..255] of Char;
    Semaforo : File;

function MyCompare(Str1,Str2:String):Integer;
Const CharSet : Array [1..2,1..26] of Char =
 (('','','','','','','','','','','','','','','','','','','','','','','','','',''),
  ('a','e','i','o','u','a','e','i','o','u','a','o','a','e','i','o','u','y','y','c','a','e','i','o','u','n'));
var R1,R2,
    NStr1,NStr2 : String;
function Convert(S:String;var NS : String):String;
var C,C2 : Integer;
begin
  NS := '';
  S := AnsiLowerCase(S);
  Result := '';
  For C := 1 to Length(S) do
  begin
    C2 := 1;
    While (C2<=26) and (S[C]<>CharSet[1,C2]) do Inc(C2);
    if (S[C]=CharSet[1,C2]) and (C2<=26) then
    begin
      NS := NS + CharSet[2,C2];
      Result := Result+'B';
    end else
    begin
      NS := NS + S[C];
      Result := Result+'A';
    end;
  end;
end;

begin
  R1 := Convert(Str1,NStr1);
  R2 := Convert(Str2,NStr2);
  if NStr1>NStr2 then Result:=1
  else if NStr1<NStr2 then Result:=-1
  else if R1>R2 then Result:=1
  else if R1<R2 then Result:=-1
  else Result:=0;
end;

begin
  if SType=1 then
  begin
    Screen.Cursor := crHourGlass;
    Enabled := False;
    While FileExists(MainPath+'NOREC.REC') do Application.ProcessMessages;
    Enabled := True;
    AssignFile(Semaforo,MainPath+'NOREC.REC');
    Rewrite(Semaforo);
  end;
  AbreArquivos;
  I := 0;
  F := FileSize(IAgenda);
  M := (F-I) div 2;
  StrUsr := EditNome.Text;
  if F>0 then
  begin
    LeRegistro(I+M);
    StrData := Agenda.Nome;
  end;
  While (StrUsr<>StrData) and (M>0) do
  begin
    if MyCompare(StrUsr,StrData)>0 then I := I+M
    else if MyCompare(StrUsr,StrData)<0 then F := I+M
    else Break;
    M := (F-I) div 2;
    LeRegistro(I+M);
    StrData := Agenda.Nome;
  end;
  if SType=1 then
  begin
    if F=0 then AddReg(0)
    else if MyCompare(StrUsr,StrData)>0 then IRegistro := I+M+1
    else if MyCompare(StrUsr,StrData)<0 then IRegistro := I+M
    else MessageBox(Handle,'Este nome j est cadastrado','Aviso',MB_ICONSTOP+MB_OK+MB_TASKMODAL);
    if (MyCompare(StrUsr,StrData)<>0) and (F<>0) then AddReg(IRegistro);
  end else if SType=2 then
  begin
    if (MyCompare(StrUsr,StrData)>0) and (I+M+1<FileSize(IAgenda)) then IRegistro := I+M+1
    else if MyCompare(StrUsr,StrData)<0 then
    begin
      if I+M>0 then IRegistro := I+M-1 else IRegistro := 0;
    end else IRegistro := I+M;
    LeRegistro(IRegistro);
    if AnsiCompareText(StrUsr,Copy(Agenda.Nome,1,Length(StrUsr)))<>0
      then MessageBox(Handle,'Nome no encontrado','Aviso',MB_ICONSTOP+MB_TASKMODAL+MB_OK);
    editNome.Text := Agenda.Nome;
    editFone.Text := Agenda.Fone;
  end;
  UpdateScreen;
  FechaArquivos;
  if SType=1 then
  begin
    CloseFile(Semaforo);
    DeleteFile(MainPath+'NOREC.REC');
    Screen.Cursor := 0;
  end;
end;

{No incio do programa, limpa os campos de edio, e inicializa os ponteiros dos
arquivos}
procedure TformAgendaMain10.FormCreate(Sender: TObject);
var C : Integer;
begin
  IRegistro := 0;
  Registro := 0;
  MainPath := Application.ExeName;
  For C := Length(MainPath) downto 1 do
  begin
    if MainPath[C]='\' then
    begin
      MainPath := Copy(MainPath,1,C);
      Break;
    end;
  end;
  AssignFile(FAgenda,MainPath+'FONES.MDF');
  AssignFile(IAgenda,MainPath+'FONES.MDI');
  AssignFile(EAgenda,MainPath+'FONES.MEI');
  editNome.Text := '';
  editFone.Text := '';
  AbreArquivos;
  UpdateScreen;
  if FileSize(IAgenda)>0 then
  begin
    LeRegistro(0);
    editNome.Text := Agenda.Nome;
    editFone.Text := Agenda.Fone;
  end;
  FechaArquivos;
end;

{Boto de adio. Elimina os espaos do fim do nome e executa a procedure de
adio/busca com o parametro correto}
procedure TformAgendaMain10.buttonAdicionaClick(Sender: TObject);
var C : Integer;
begin
  C := Length(editNome.Text);
  While editNome.Text[C]=' ' do Dec(C);
  editNome.Text := Copy(editNome.Text,1,C);
  if editNome.Text='' then
  begin
    MessageBox(Handle,'Voc deve digitar um nome','Aviso!',MB_ICONSTOP+MB_TASKMODAL+MB_OK);
    editNome.SetFocus;
  end;
  AdicionaBusca(1);
end;

{Boto de busca. Elimina os espaos do fim do nome e executa a procedure de
adio/busca com o parametro correto}
procedure TformAgendaMain10.buttonProcuraClick(Sender: TObject);
var C : Integer;
begin
  C := Length(editNome.Text);
  While editNome.Text[C]=' ' do Dec(C);
  editNome.Text := Copy(editNome.Text,1,C);
  if editNome.Text='' then
  begin
    MessageBox(Handle,'Voc deve digitar um nome','Aviso!',MB_ICONSTOP+MB_TASKMODAL+MB_OK);
    editNome.SetFocus;
  end;
  AdicionaBusca(2);
end;

{Exibe o registro anterior de acordo com o ndice. No  necessria verificao, pois este
boto s poder ser clicado se houver um registro anterior}
procedure TformAgendaMain10.buttonPrevClick(Sender: TObject);
begin
  AbreArquivos;
  Dec(IRegistro);
  LeRegistro(IRegistro);
  UpdateScreen;
  FechaArquivos;
  editNome.Text := Agenda.Nome;
  editFone.Text := Agenda.Fone;
end;

{Exibe o prximo registro de acordo com o ndice. No  necessria verificao, pois este
boto s poder ser clicado se houver um prximo registro}
procedure TformAgendaMain10.buttonNextClick(Sender: TObject);
begin
  AbreArquivos;
  Inc(IRegistro);
  LeRegistro(IRegistro);
  UpdateScreen;
  FechaArquivos;
  editNome.Text := Agenda.Nome;
  editFone.Text := Agenda.Fone;
end;

{Exclui um registro. Nenhum registro  efetivamente excludo, pois reescrever o arquivo
de dados pode levar muito tempo. O ponteiro para o registro  removido do ndice e 
includo no ndice de registros excludos. O ndice de dados  reescrito. Mais uma vez, o
semforo  necessrio.}
procedure TformAgendaMain10.buttonExcluiClick(Sender: TObject);
var F : File of LongInt;
    Semaforo : File;
    R : LongInt;
begin
  if MessageBox(Handle,'Deseja mesmo excluir este registro?','Excluso',MB_ICONQUESTION+MB_TASKMODAL+MB_OK+MB_YESNO)=ID_YES
  then
  begin
    Screen.Cursor := crHourGlass;
    Enabled := False;
    While FileExists(MainPath+'NOREC.REC') do Application.ProcessMessages;
    Enabled := True;
    AssignFile(Semaforo,MainPath+'NOREC.REC');
    Rewrite(Semaforo);
    AbreArquivos;
    Seek(IAgenda,IRegistro);
    Read(IAgenda,Registro);
    AssignFile(F,MainPath+'TEMP.TMP');
    Rewrite(F);
    Seek(IAgenda,0);
    While not Eof(IAgenda) do
    begin
      if FilePos(IAgenda)<>IRegistro then
      begin
        Read(IAgenda,R);
        Write(F,R);
      end else Seek(IAgenda,FilePos(IAgenda)+1);
    end;
    CloseFile(F);
    CloseFile(IAgenda);
    DeleteFile(MainPath+'FONES.MDI');
    RenameFile(MainPath+'TEMP.TMP','FONES.MDI');
    Reset(IAgenda);
    Seek(EAgenda,FileSize(EAgenda));
    Write(EAgenda,Registro);
    IRegistro := 0;
    UpdateScreen;
    if FileSize(IAgenda)>0 then
    begin
      LeRegistro(0);
      editNome.Text := Agenda.Nome;
      editFone.Text := Agenda.Fone;
    end else
    begin
      editNome.Text := '';
      editFone.Text := '';
    end;
    FechaArquivos;
    CloseFile(Semaforo);
    DeleteFile(MainPath+'NOREC.REC');
    Screen.Cursor := 0;
  end;
end;

end.
